#ifndef __C4DPAINTER_H
#define __C4DPAINTER_H

#include "c4d_string.h"
#include "operatingsystem.h"

class BaseDocument;

void *SendPainterCommand(LONG command, BaseDocument *doc, PaintTexture *tex, BaseContainer *bc);
	#define PAINTER_SAVETEXTURE			1000 // save textures (if doc -> all doc associated, if -> tex only tex, otherwise all textures)
	#define	PAINTER_BRINGTOFRONT		1001 // brings the bp window to front

//-------
// new in BP2
//-------

struct TempUVHandle
{
	private:
		TempUVHandle();
		~TempUVHandle();

	public:

		// not allowed to change
		LONG GetMode();
		Vector* GetPoint();
		Polygon* GetPoly();
		BaseSelect* GetPolySel();
		BaseSelect* GetUVPointSel(); // 4*polycnt!!! 0..3 = a,b,c,d
		LONG GetPointCount();
		LONG GetPolyCount();
		BaseObject* GetBaseObject();
		Bool IsEditable();

		// allowed to change
		UVWStruct* GetUVW();

		Bool SetUVW(UVWStruct* uv);
};

TempUVHandle *GetActiveUVSet(BaseDocument* doc, LONG flags);
	#define GETACTIVEUVSET_CHECKENABLING				(1<<0)
	#define GETACTIVEUVSET_UVWS									(1<<1)
	#define GETACTIVEUVSET_POLYS								(1<<2)
	#define GETACTIVEUVSET_POLYSELECTION				(1<<3)
	#define GETACTIVEUVSET_POINTS								(1<<4)
	#define GETACTIVEUVSET_POINTSELECTION				(1<<5)
	#define GETACTIVEUVSET_OBJECT								(1<<6)
	#define GETACTIVEUVSET_MODE									(1<<7)

	#define GETACTIVEUVSET_ALL_CHECKENABLING		(0xFFFF)
	#define GETACTIVEUVSET_ALL									(0xFFFF & ~GETACTIVEUVSET_CHECKENABLING)

void FreeActiveUVSet(TempUVHandle *handle);

//-------

//-------

Bool CallUVCommand(Vector *padr,LONG PointCount, Polygon *polys, LONG lPolyCount, UVWStruct *uvw, BaseSelect *polyselection,
                   BaseSelect* pointselection, BaseObject*op, LONG mode, LONG cmdid, const BaseContainer &settings);
	#define UVCOMMAND_OPTIMALMAPPING		10000
	#define UVCOMMAND_OPTIMALCUBICMAPPING			10001
  #define UVCOMMAND_REALIGN           10002
		#define OPTIMALMAPPING_PRESERVEORIENTATION	1000	// BOOL (a, o, r)
		#define OPTIMALMAPPING_STRETCHTOFIT					1001	// BOOL (a, o, r)
		#define OPTIMALMAPPING_DISTORTION						1002	// REAL (o)
		#define OPTIMALMAPPING_SPACING							1003	// REAL (a, o, r)
		#define OPTIMALMAPPING_AREAFAK							1004  // REAL (a)
		#define OPTIMALMAPPING_TWOD									1005  // BOOL (a)
    #define OPTIMALMAPPING_PROGRESSBAR          1006  // BOOL (a, o, r)
    #define OPTIMALMAPPING_RELAXCOUNT           1007  // LONG (a, o)
  #define UVCOMMAND_RELAX             10003
    #define UV_COMMAND_RELAX_KEEP_BORDER        1010  // BOOL
    #define UV_COMMAND_RELAX_KEEP_NEIGHBORS     1011  // BOOL
  #define UVCOMMAND_COPY_UV           10004
  #define UVCOMMAND_PASTE_UV          10005
  #define UVCOMMAND_MAX_UV            10006
  #define UVCOMMAND_FLIP_SEQUENCE     10007
  #define UVCOMMAND_MOVE_DOWN_SEQUENCE  10008
  #define UVCOMMAND_MOVE_UP_SEQUENCE    10009
  #define UVCOMMAND_TERRACE           10010
  #define UVCOMMAND_FIT_TO_CANVAS     10011
  #define UVCOMMAND_TRANSFORM         10012
    #define UVCOMMAND_TRANSFORM_MOVE_X          1020 // REAL
    #define UVCOMMAND_TRANSFORM_MOVE_Y          1021 // REAL
    #define UVCOMMAND_TRANSFORM_SCALE_X         1022 // REAL
    #define UVCOMMAND_TRANSFORM_SCALE_Y         1023 // REAL
    #define UVCOMMAND_TRANSFORM_ANGLE           1024 // REAL (Angle in Radians)

//-------

PaintTexture *CreateNewTexture(const Filename &path, const BaseContainer &settings);
Bool GetTextureDefaults(LONG channel,BaseContainer &settings);
	#define TEXTURE_FILEFORMAT			1000 // LONG
	#define TEXTURE_WIDTH						1001 // LONG
	#define TEXTURE_HEIGHT					1002 // LONG
	#define TEXTURE_MODE						1003 // enum rgb,grey
		#define TEXTURE_MODE_GREY8				(2)
		#define TEXTURE_MODE_RGB					(4)
	#define TEXTURE_COLOR						1004 // vector
	#define TEXTURE_SAVE_IMMEDIATLY	1005 // bool: flag if save immediatly, otherwise it's only created in memory


LONG IdentifyImage(const Filename &texpath);

#endif
